# Prof-TC
# Avril 2022
# Caractéristique Lampe
# Tracé de U=f(I) pour une lampe

#Affichage du nom du programme
print("_________________________________________________________")
print("Caracteristique d'une Lampe")
print("_________________________________________________________")

#Importation des bibliothèques
import matplotlib.pyplot as plt
import numpy as np

#Vleurs expérimentales à modifier selon l'expérience (U en volt et I en milliampère)

ImA=[0, 18, 35, 51, 58, 66, 80, 89, 95, 103, 108, 115, 119, 124, 129]
U=[0, 0.25, 0.88, 1.72, 2.16, 2.72, 3.76, 4.72, 5.28, 6.08, 6.64, 7.48, 7.88, 8.51, 9.20]

# Nombre de points expérimentaux
K=len(U)

# Détermination des valeurs de I en Ampère
I=[]
for i in range(K):
    I.append(ImA[i]/1000)

#Affichage des valeurs expérimentales et du nombre de points
print("valeurs de I: ",I)
print("valeurs de U: ",U)
print()
print("Il y a ",K," couples de points")
print("_________________________________________________________")

#Initialisation des variables
Imin=I[0]
Umin=U[0]
Imax=I[len(I)-1]
Umax=U[len(U)-1]

# Initialisation de la figure
fig, ax = plt.subplots()

#Tracé des axes, labels et titre du graphique
plt.axis([Imin, Imax, Umin, Umax])
plt.xlabel('I (A)',color='green', fontsize=20)
plt.ylabel('U (V)',color='green', fontsize=20)
plt.title("Caractéristique d'une Lampe", color='red', fontsize=10)
plt.grid()

#Tracé des valeurs expérimentales
plt.scatter(I,U,marker='o',color='r',linewidth = 4)

#Interpolation de la courbe par un polynome du second degré
x=I
y=U
a, b, c = np.polyfit(x, y, 2)  # Modélisation par un polynome de degré 2
x = np.array(x)               # Création d'un tableau Numpy pour x
y_modele = a*x**2+b*x+c       # Création d'un tableau Numpy pour y du modèle
plt.plot(x, y_modele, 'b-', label = "modèle")  # Courbe du modèle

#Ecriture de l'équation de la caractéristique
A=round(a,2)
B=round(b,2)
C=round(c,2)
plt.text((Imax)/2, Umax-Umax*0.1, "U = "+str(A)+" x I^2 + "+str(B)+ " x I + "+str(C), color='red', fontsize=12,horizontalalignment = 'center')

#Affichage du graphique
plt.show()

# Sauvegarde de la figure dans le dossier où se trouve le programme
fig.savefig("CaracteristiqueLampe")

print("_________________________________________________________")

#Fin du programme